import org.multiply.processing.TimedEventGenerator;

import oscP5.*;
import netP5.*;
import controlP5.*;

String nameOfHssEtienneTrack = "HSS_Etienne_2_3mix.wav";
String nameOfHss2Track = "HSS_Ecuries_40mix.wav";

int largeurBTN = 70;
int hauteurBTN = 20;

//Capteurs
boolean capteur1 = false;
boolean capteur2 = false;
boolean capteur3 = false;
boolean capteur4 = false;

int countDownCapteur1;
int countDownCapteur2;
int countDownCapteur3;
int countDownCapteur4;

String IP1 = "192.168.1.201";
String IP2 = "192.168.1.209";
String IP3 = "192.168.1.218";
String IP4 = "192.168.1.211";

String LastStart = "  --:--";
int countdownMillis;
boolean isPlaying = false;
float timeCycle = 20.0;


ControlP5 cp5;

OscP5 oscP5;
NetAddress Raspi1;
NetAddress Raspi2;
NetAddress Raspi3;
NetAddress Raspi4;
NetAddress Raspi5;
NetAddress Raspi6;
NetAddress Raspi7;
NetAddress Raspi8;
NetAddress Raspi9;
NetAddress Raspi10;
NetAddress Raspi11;
NetAddress Raspi12;
NetAddress Raspi13;
NetAddress Raspi14;
NetAddress Raspi15;
NetAddress Raspi16;
NetAddress Raspi17;
NetAddress Raspi18;

NetAddress RaspiHSS1;
NetAddress RaspiHSS2;

//Only Raspis in trees, not HSS
NetAddressList myRaspis = new NetAddressList();

private TimedEventGenerator TimeArtist1;
private TimedEventGenerator TimeArtist2;
private TimedEventGenerator TimeArtist3;
private TimedEventGenerator TimeArtist4;
private TimedEventGenerator TimeArtist5;
//Test
private TimedEventGenerator TimeArtist6;
//HSS
private TimedEventGenerator TimeArtist7;
private TimedEventGenerator TimeArtist8;

//private TimedEventGenerator FirstDelay;


Table table;

// Corsin
int TimerArtist1;

// Ben
int TimerArtist2;

// PL
int TimerArtist3;

// Gilles
int TimerArtist4;

// Aurélien
int TimerArtist5;

// Test
int TimerArtist6 = 3;

// HSS Etienne
int TimerArtist7;

// HSS 2
int TimerArtist8;

boolean shutdownAsked = false;

void setup() {
  size(600, 400);
  background(0);
  createUI();
  /* start oscP5, listening for incoming messages at port 12000 */
  oscP5 = new OscP5(this, 12000);
  /* myRemoteLocation is a NetAddress. a NetAddress takes 2 parameters,
   * an ip address and a port number. myRemoteLocation is used as parameter in
   * oscP5.send() when sending osc packets to another computer, device, 
   * application. usage see below. for testing purposes the listening port
   * and the port of the remote location address are the same, hence you will
   * send messages back to this sketch.
   */
  Raspi9 = new NetAddress("192.168.1.209", 7120);
  Raspi8 = new NetAddress("192.168.1.208", 7120);
  Raspi7 = new NetAddress("192.168.1.207", 7120);
  Raspi6 = new NetAddress("192.168.1.206", 7120);
  Raspi5 = new NetAddress("192.168.1.205", 7120);
  Raspi4 = new NetAddress("192.168.1.204", 7120);
  Raspi3 = new NetAddress("192.168.1.203", 7120);
  Raspi2 = new NetAddress("192.168.1.202", 7120);
  Raspi1 = new NetAddress("192.168.1.201", 7120);

  Raspi18 = new NetAddress("192.168.1.218", 7120);
  Raspi17 = new NetAddress("192.168.1.217", 7120);
  Raspi16 = new NetAddress("192.168.1.216", 7120);
  Raspi15 = new NetAddress("192.168.1.215", 7120);
  Raspi14 = new NetAddress("192.168.1.214", 7120);
  Raspi13 = new NetAddress("192.168.1.213", 7120);
  Raspi12 = new NetAddress("192.168.1.212", 7120);
  Raspi11 = new NetAddress("192.168.1.211", 7120);
  Raspi10 = new NetAddress("192.168.1.210", 7120);

  RaspiHSS1 = new NetAddress("192.168.1.219", 7120);
  RaspiHSS2 = new NetAddress("192.168.1.220", 7120);

  myRaspis.add(Raspi1);
  myRaspis.add(Raspi2);
  myRaspis.add(Raspi3);
  myRaspis.add(Raspi4);
  myRaspis.add(Raspi5);
  myRaspis.add(Raspi6);
  myRaspis.add(Raspi7);
  myRaspis.add(Raspi8);
  myRaspis.add(Raspi9);
  myRaspis.add(Raspi10);
  myRaspis.add(Raspi11);
  myRaspis.add(Raspi12);
  myRaspis.add(Raspi13);
  myRaspis.add(Raspi14);
  myRaspis.add(Raspi15);
  myRaspis.add(Raspi16);
  myRaspis.add(Raspi17);
  myRaspis.add(Raspi18);

  table = loadTable("boucles.csv", "header");

  TimerArtist1 = table.getInt(0, 1);
  TimerArtist2 = table.getInt(1, 1);
  TimerArtist3 = table.getInt(2, 1);
  TimerArtist4 = table.getInt(3, 1);
  TimerArtist5 = table.getInt(4, 1);
  //HSS
  TimerArtist7 = table.getInt(5, 1);
  TimerArtist8 = table.getInt(6, 1);

  println("Corsin " + TimerArtist1);
  println("Ben " + TimerArtist2);
  println("PL " + TimerArtist3);
  println("Gilles " + TimerArtist4);
  println("Aurelien " + TimerArtist5);
  println("HSS Etienne " + TimerArtist7);
  println("HSS 2 " + TimerArtist8);
  
  TimeArtist7 = new TimedEventGenerator(this, "HSS_Etienne", false, TimerArtist7*1000);
  TimeArtist8 = new TimedEventGenerator(this, "HSS_2", false, TimerArtist8*1000);
  TimeArtist1 = new TimedEventGenerator(this, "Artist1", false, TimerArtist1*1000);
  TimeArtist2 = new TimedEventGenerator(this, "Artist2", false, TimerArtist2*1000);
  TimeArtist3 = new TimedEventGenerator(this, "Artist3", false, TimerArtist3*1000);
  TimeArtist4 = new TimedEventGenerator(this, "Artist4", false, TimerArtist4*1000);
  TimeArtist5 = new TimedEventGenerator(this, "Artist5", false, TimerArtist5*1000);
  TimeArtist6 = new TimedEventGenerator(this, "Artist6", false, TimerArtist6*1000);
  //FirstDelay = new TimedEventGenerator(this, "Start", true, 30000);
  
}

PVector btnPosition (int ColX, int ColY)
{
  int largeurCol = 100;
  int hauteurCol = 50;
  int marginHoriz = 15;
  int marginVert = 60;

  PVector myPVector = new PVector();
  myPVector.x = marginHoriz+largeurCol*ColX;
  myPVector.y = marginVert+hauteurCol*ColY;

  return myPVector;
}

void createUI()
{


  // UI
  cp5 = new ControlP5(this);

  //Test
  cp5.addBang("Test")
    .setPosition(btnPosition(0, 5).x, btnPosition(0, 5).y )
    .setSize(largeurBTN, hauteurBTN)
    ;

  //HSS Etienne
  cp5.addBang("HSS_Etienne")
    .setPosition(btnPosition(1, 5).x, btnPosition(1, 5).y )
    .setSize(largeurBTN, hauteurBTN)
    ;

  //All at the same time
  cp5.addBang("Parcours")
    .setPosition(btnPosition(0, 6).x, btnPosition(0, 6).y )
    .setSize(largeurBTN, hauteurBTN)
    ;

  //All at the same time
  cp5.addBang("HSS_2")
    .setPosition(btnPosition(1, 6).x, btnPosition(1, 6).y )
    .setSize(largeurBTN, hauteurBTN)
    ;

  //Stop All
  cp5.addBang("StopAllSounds")
    .setPosition(btnPosition(4, 5).x, btnPosition(4, 5).y )
    .setSize(largeurBTN, hauteurBTN)
    ;

  //Stop All
  cp5.addBang("Shutdown")
    .setPosition(btnPosition(5, 5).x, btnPosition(5, 5).y )
    .setSize(largeurBTN, hauteurBTN)
    ;

  //Reboot
  cp5.addBang("Reboot")
    .setPosition(btnPosition(5, 6).x, btnPosition(5, 6).y )
    .setSize(largeurBTN, hauteurBTN)
    ;

  cp5.addLabel("Capteur1")
    .setText("Capteur 1")
    .setPosition(width/2-235, height/2-5);

  cp5.addLabel("Capteur2")
    .setText("Capteur 2")
    .setPosition(width/2-115, height/2-5);

  cp5.addLabel("Capteur3")
    .setText("Capteur 3")
    .setPosition(width/2+65, height/2-5);

  cp5.addLabel("Capteur4")
    .setText("Capteur 4")
    .setPosition(width/2+185, height/2-5);
    
  cp5.addTextfield("Heure")
     .setPosition(20,20)
     .setSize(30,20)
     .setAutoClear(false)
     .lock()
     ;
     
  cp5.addTextfield("Last Start")
     .setPosition(20,60)
     .setSize(30,20)
     .setAutoClear(false)
     .lock()
     ;
     
  // add a vertical slider
  cp5.addSlider("CYCLE-20MIN")
     .setPosition(20,120)
     .setSize(560,15)
     .setRange(0,timeCycle)
     .setValue(0)
     .lock()
     ;
  
  // reposition the Label for controller 'slider'
  cp5.getController("CYCLE-20MIN").getValueLabel().align(ControlP5.LEFT, ControlP5.BOTTOM_OUTSIDE).setPaddingX(0);
  cp5.getController("CYCLE-20MIN").getCaptionLabel().align(ControlP5.RIGHT, ControlP5.BOTTOM_OUTSIDE).setPaddingX(0);
}

public void Test() {
  println ("Test");
  TimeArtist6 = new TimedEventGenerator(this, "Artist6", true, TimerArtist6*1000);
}

public void Parcours() {

  //HSS
  HSS_Etienne();
  TimeArtist7 = new TimedEventGenerator(this, "HSS_Etienne", true, TimerArtist7*1000);
  HSS_2();
  TimeArtist8 = new TimedEventGenerator(this, "HSS_2", true, TimerArtist8*1000);
  // Parcours
  Artist1();
  delay(500);
  Artist2();
  delay(500);
  Artist3();
  delay(500);
  Artist4();
  delay(500);
  Artist5();
  delay(500);
  TimeArtist1 = new TimedEventGenerator(this, "Artist1", true, TimerArtist1*1000);
  delay(500);
  TimeArtist2 = new TimedEventGenerator(this, "Artist2", true, TimerArtist2*1000);
  delay(500);
  TimeArtist3 = new TimedEventGenerator(this, "Artist3", true, TimerArtist3*1000);
  delay(500);
  TimeArtist4 = new TimedEventGenerator(this, "Artist4", true, TimerArtist4*1000);
  delay(500);
  TimeArtist5 = new TimedEventGenerator(this, "Artist5", true, TimerArtist5*1000);
}

public void StopAllSounds() {
  OscMessage myMessage = new OscMessage("/note/1");
  myMessage.add("stop all"); /* add an int to the osc message */
  /* send the message */
  for (int i =0; i<myRaspis.size(); i++)
  {
    NetAddress theRaspi = myRaspis.get(i);
    println ("Sent message -- Stop All -- to "+theRaspi.address());
    oscP5.send(myMessage, theRaspi);
  }

  //HSS
  oscP5.send(myMessage, RaspiHSS1);
  oscP5.send(myMessage, RaspiHSS2);

  TimeArtist7.setEnabled(false);
  TimeArtist8.setEnabled(false);

  TimeArtist1.setEnabled(false);
  TimeArtist2.setEnabled(false);
  TimeArtist3.setEnabled(false);
  TimeArtist4.setEnabled(false);
  TimeArtist5.setEnabled(false);
  if (TimeArtist6.isEnabled())
  {
    TimeArtist6.setEnabled(false);
  }
}

public void Shutdown() {
  OscMessage myMessage = new OscMessage("/note/1");
  myMessage.add("dodo"); /* add an int to the osc message */
  /* send the message */
  for (int i =0; i<myRaspis.size(); i++)
  {
    NetAddress theRaspi = myRaspis.get(i);
    println ("Sent message -- Dodo -- to "+theRaspi.address());
    oscP5.send(myMessage, theRaspi);
  }
  oscP5.send(myMessage, RaspiHSS1);
  oscP5.send(myMessage, RaspiHSS2);
}

public void Reboot() {
  OscMessage myMessage = new OscMessage("/note/1");
  myMessage.add("reboot"); /* add an int to the osc message */
  /* send the message */
  for (int i =0; i<myRaspis.size(); i++)
  {
    NetAddress theRaspi = myRaspis.get(i);
    println ("Sent message -- Reboot -- to "+theRaspi.address());
    oscP5.send(myMessage, theRaspi);
  }
  oscP5.send(myMessage, RaspiHSS1);
  oscP5.send(myMessage, RaspiHSS2);
}

void Start()
{
  println("Start");

  //HSS
  HSS_Etienne();
  TimeArtist7 = new TimedEventGenerator(this, "HSS_Etienne", true, TimerArtist7*1000);

  HSS_2();
  TimeArtist8 = new TimedEventGenerator(this, "HSS_2", true, TimerArtist8*1000);

  Artist1();
  delay(500);
  Artist2();
  delay(500);
  Artist3();
  delay(500);
  Artist4();
  delay(500);
  Artist5();
  delay(500);
  TimeArtist1 = new TimedEventGenerator(this, "Artist1", true, TimerArtist1*1000);
  delay(500);
  TimeArtist2 = new TimedEventGenerator(this, "Artist2", true, TimerArtist2*1000);
  delay(500);
  TimeArtist3 = new TimedEventGenerator(this, "Artist3", true, TimerArtist3*1000);
  delay(500);
  TimeArtist4 = new TimedEventGenerator(this, "Artist4", true, TimerArtist4*1000);
  delay(500);
  TimeArtist5 = new TimedEventGenerator(this, "Artist5", true, TimerArtist5*1000);

  //FirstDelay.setEnabled(false);
}

void drawInterface()
{
  noFill();
  stroke(255);
  line(300, 300, 300, 400);

  fill(200);
  rectMode(CENTER);
  rect(width/2, height/2, 40, 40);
}

void drawCapteur(boolean State, int theX, int theY)
{
  if (State == false)
  { 
    fill(255, 0, 0);
  } else
  { 
    fill(0, 255, 0);
  }
  noStroke();
  rectMode(CENTER);
  rect(theX, theY, 20, 20);
}

void checkCapteur()
{
  if (millis() - countDownCapteur1>5000)capteur1=false;
  if (millis() - countDownCapteur2>5000)capteur2=false;
  if (millis() - countDownCapteur3>5000)capteur3=false;
  if (millis() - countDownCapteur4>5000)capteur4=false;
}

void draw() {
  background(0);
  drawInterface();
  checkCapteur();
  drawCapteur(capteur1, width/2-250, height/2);
  drawCapteur(capteur2, width/2-50, height/2);
  drawCapteur(capteur3, width/2+50, height/2);
  drawCapteur(capteur4, width/2+250, height/2);
  
  //Infos numeriques affichées
  cp5.get(Textfield.class,"Heure").setText( "  "+hour()+":"+minute());
  cp5.get(Textfield.class,"Last Start").setText(LastStart);
  
  if (isPlaying)
  {
    float posCursor = ((float)millis()-(float)countdownMillis)/1000f/60f;
    cp5.getController("CYCLE-20MIN").setValue(posCursor);
    if (cp5.getController("CYCLE-20MIN").getValue()>=timeCycle)
    {
     StopAllSounds();
     isPlaying = false;
     cp5.getController("CYCLE-20MIN").setValue(0);
    }
  }
  
  
  if (hour()==21 && minute()==45)
  {
    Shutdown();
  } else if (hour() == 21 && minute()==50 && shutdownAsked == false)
  {
    shutdownMyself();
    shutdownAsked = true;
  }
}

public void HSS_Etienne()
{
  if (hour()>6 && hour()<22)
  {
    println ("Sent message -- Play Etienne --");
    OscMessage myMessage = new OscMessage("/note/1");
    myMessage.add(nameOfHssEtienneTrack); /* add an int to the osc message */
    /* send the message */
    oscP5.send(myMessage, RaspiHSS1);
  }
}

public void HSS_2()
{
  if (hour()>6 && hour()<22)
  {
    println ("Sent message -- Play HSS 2 --");
    OscMessage myMessage = new OscMessage("/note/1");
    myMessage.add(nameOfHss2Track); /* add an int to the osc message */
    /* send the message */
    oscP5.send(myMessage, RaspiHSS2);
  }
}

public void Artist1() {
  String theArtist = "Corsin";
  if (hour()>6 && hour()<22)
  {
    println ("Sent message -- Play 1 --");
    for (int i =0; i<myRaspis.size(); i++)
    {
      NetAddress theRaspi = myRaspis.get(i);
      String theHPs = returnHP(i);
      String theSound = theArtist + theHPs;
      OscMessage myMessage = new OscMessage("/note/1");
      myMessage.add(theSound);
      //println ("Sent message -- Play "+theSound+" -- to "+theRaspi.address());
      oscP5.send(myMessage, theRaspi);
    }
  }
}

public void Artist2() {
  String theArtist = "Ben";
  if (hour()>6 && hour()<22)
  {
    println ("Sent message -- Play 2 --");
    for (int i =0; i<myRaspis.size(); i++)
    {
      NetAddress theRaspi = myRaspis.get(i);
      String theHPs = returnHP(i);
      String theSound = theArtist + theHPs;
      OscMessage myMessage = new OscMessage("/note/1");
      myMessage.add(theSound);
      //println ("Sent message -- Play "+theSound+" -- to "+theRaspi.address());
      oscP5.send(myMessage, theRaspi);
    }
  }
}

public void Artist3() {
  String theArtist = "PL";
  if (hour()>6 && hour()<22)
  {
    println ("Sent message -- Play 3 --");
    for (int i =0; i<myRaspis.size(); i++)
    {
      NetAddress theRaspi = myRaspis.get(i);
      String theHPs = returnHP(i);
      String theSound = theArtist + theHPs;
      OscMessage myMessage = new OscMessage("/note/1");
      myMessage.add(theSound);
      //println ("Sent message -- Play "+theSound+" -- to "+theRaspi.address());
      oscP5.send(myMessage, theRaspi);
    }
  }
}

public void Artist4() {
  String theArtist = "Gilles";
  if (hour()>6 && hour()<22)
  {
    println ("Sent message -- Play 4 --");
    for (int i =0; i<myRaspis.size(); i++)
    {
      NetAddress theRaspi = myRaspis.get(i);
      String theHPs = returnHP(i);
      String theSound = theArtist + theHPs;
      OscMessage myMessage = new OscMessage("/note/1");
      myMessage.add(theSound);
      //println ("Sent message -- Play "+theSound+" -- to "+theRaspi.address());
      oscP5.send(myMessage, theRaspi);
    }
  }
}

public void Artist5() {
  String theArtist = "Aurelien";
  if (hour()>6 && hour()<22)
  {
    println ("Sent message -- Play 5 --");
    for (int i =0; i<myRaspis.size(); i++)
    {
      NetAddress theRaspi = myRaspis.get(i);
      String theHPs = returnHP(i);
      String theSound = theArtist + theHPs;
      OscMessage myMessage = new OscMessage("/note/1");
      myMessage.add(theSound);
      //println ("Sent message -- Play "+theSound+" -- to "+theRaspi.address());
      oscP5.send(myMessage, theRaspi);
    }
  }
}

public void Artist6() {
  String theArtist = "Test";
  println ("Sent message -- Play Test --");
  for (int i =0; i<myRaspis.size(); i++)
  {
    NetAddress theRaspi = myRaspis.get(i);
    String theHPs = returnHP(i);
    String theSound = theArtist + theHPs;
    OscMessage myMessage = new OscMessage("/note/1");
    myMessage.add(theSound);
    //println ("Sent message -- Play "+theSound+" -- to "+theRaspi.address());
    oscP5.send(myMessage, theRaspi);
  }
}




public void shutdownMyself()
{
  try
  {
    String command = "sudo shutdown now";
    Process child = Runtime.getRuntime().exec(command);
  }
  catch (IOException e)
  {
  }
}


public String returnHP(int HP)
{
  String HpNumbers = "";
  if (HP>8) {
    HP-=9;
  }
  switch(HP) {
  case 0:
    HpNumbers = "0102_1920.wav";
    break;
  case 1:
    HpNumbers = "0304_2122.wav";
    break;
  case 2:
    HpNumbers = "0506_2324.wav";
    break;
  case 3:
    HpNumbers = "0708_2526.wav";
    break;
  case 4:
    HpNumbers = "0910_2728.wav";
    break;
  case 5:
    HpNumbers = "1112_2930.wav";
    break;
  case 6:
    HpNumbers = "1314_3132.wav";
    break;
  case 7:
    HpNumbers = "1516_3334.wav";
    break;
  case 8:
    HpNumbers = "1718_3536.wav";
    break;
  }
  return HpNumbers;
}

void oscEvent(OscMessage theOscMessage) {
  //println(theOscMessage);
  /* check if theOscMessage has the address pattern we are looking for. */
  if (theOscMessage.checkAddrPattern("/pir")==true) {
    /* check if the typetag is the right one. */
    if (theOscMessage.checkTypetag("s")) {
      String value = theOscMessage.get(0).stringValue(); 
      print("### received an osc message /pir with typetag string.");
      println(" value: "+value);
      if (value.equals(IP1))
      {
        capteur1 = true;
        countDownCapteur1 = millis();
      } else if (value.equals(IP2))
      {
        capteur2 = true;
        countDownCapteur2 = millis();
      } else if (value.equals(IP3))
      {
        capteur3 = true;
        countDownCapteur3 = millis();
      } else if (value.equals(IP4))
      {
        capteur4 = true;
        countDownCapteur4 = millis();
      }
      countdownMillis = millis();
      LastStart = "  "+hour()+":"+minute();
      println("Cycle started");
      if (isPlaying == false)
      {
        isPlaying = true;
        Start();
      }
      return;
    }
  }
  println("### received an osc message. with address pattern "+
    theOscMessage.addrPattern()+" typetag "+ theOscMessage.typetag());
}