#!/usr/bin/python
#
# Detecter des mouvements avec un capteur infrarouge
#
#
# Importation des librairies pythons
import RPi.GPIO as GPIO
import time
import urllib
import os
import OSC

import socket
import fcntl
import struct

def get_ip_address(ifname):
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    return socket.inet_ntoa(fcntl.ioctl(
        s.fileno(),
        0x8915,  # SIOCGIFADDR
        struct.pack('256s', ifname[:15])
    )[20:24])

ip = get_ip_address('eth0')  # '192.168.0.110'

# Utiliser les BCM GPIO et pas les numeros des pins sur P1
GPIO.setmode(GPIO.BCM)

# Pin GPIO utilisee
GPIO_PIR = 23

# Init OSC
client = OSC.OSCClient()
msg = OSC.OSCMessage()
msg.setAddress("/pir")
msg.append(ip)

# Configurer la pin 8 en entree
GPIO.setup(GPIO_PIR,GPIO.IN)

# Initialisation des variables
Current_State  = 0
Previous_State = 0

try:
  print "Attente detection..."
  # Boucle jusqu a ce que la sortie du capteur passe a 0
  while GPIO.input(GPIO_PIR)==1:
    Current_State = 0
  print " Pret"

  # Tourne en boucle jusqu'a ce que l utilisateur quitte (par CTRL+C)
  while True :

    # Lire l'etat du capteur
    Current_State = GPIO.input(GPIO_PIR)
    if Current_State==1 and Previous_State==0:
      # Le detecteur a envoye un signal
      print " Mouvement detecte !"
      try:
          client.sendto(msg, ('192.168.1.200', 12000))
          #msg.clearData()
      except:
          print 'Connection refused'
		
      # On attend  secondes
      time.sleep(2)
      # On enregistre l'ancien etat
      Previous_State=1
    elif Current_State==0 and Previous_State==1:
      # Le capteur est a nouveau pret
      print " Pret "
      Previous_State=0

    # On attend 1 seconde
    time.sleep(0.5)

except KeyboardInterrupt:
    print " Quit"
# Reinitialisation des parametres GPIOs
GPIO.cleanup()
