
from OSC import OSCServer
import sys
from time import sleep
import vlc
import os.path
import os

import socket
import fcntl
import struct

def get_ip_address(ifname):
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    return socket.inet_ntoa(fcntl.ioctl(
        s.fileno(),
        0x8915,  # SIOCGIFADDR
        struct.pack('256s', ifname[:15])
    )[20:24])

ip = get_ip_address('eth0')  # '192.168.0.110'

print( "waiting for OSC commands on %s" % ip)
#server = OSCServer( ("192.168.1.42", 7120) )
server = OSCServer( ( ip, 7120) )
server.timeout = 0
run = True

val=""
ListP = []

SoundPath="/home/pi/osc/sound/"

def handle_timeout(self):
    self.timed_out = True

def setVolume():
    #print ("got volume command '%i'" % vol)
    for ( name, ptruc) in ListP:
        ptruc.audio_set_volume(50)

import types
server.handle_timeout = types.MethodType(handle_timeout, server)

print "Loading VLC component"

instance=vlc.Instance()
#Play each media -> loop mode
#instance=vlc.Instance('--input-repeat=-1')



def user_callback(path, tags, args, source):
    global val 
    val = str (args[0])

server.addMsgHandler( "/note/1", user_callback )

def noteplayer (path):

    global val
    global ListP

    #c1 = pygame.mixer.Channel(1)
    #c2 = pygame.mixer.Channel(2)       

    if val != "":
        if ("stop all" == val) :
            print ("got command '%s'" % val)
            for ( name, ptruc) in ListP:
               ptruc.stop()
        elif ("dodo" == val) :
            print ("ciao")
            os.system("sudo shutdown -h now")
        elif ("reboot" == val) :
            print ("reboot")
            os.system("sudo reboot")
        elif os.path.isfile(SoundPath+val):
            print ( "play sound '%s' in dir '%s'" % ( val, SoundPath))
            SoundFilename = SoundPath+val
            found = False
            for ( name, ptruc) in ListP:
                if val == name :
                    print ("stop playing '%s'" % (val))
                    ptruc.stop()
                    print ("restart '%s'" % (val))
                    ptruc.play()
                    found = True
            if not(found) :
                #player=instance.media_player_new()
                #media = instance.media_new(SoundFilename)
                #player.set_media(media)
                #player.play()
                #player.audio_set_volume(50)
                #ListP = ListP + [(val, player)]
                p = vlc.MediaPlayer(SoundFilename)
                p.play()
                p.audio_set_volume(50)
                ListP = ListP + [(val, p)]
        else :
            print ("wtf is '%s'" % val)

        val = ""
  
        

def each_frame():
    # clear timed_out flag
    server.timed_out = False
    # handle all pending requests then return
    while not server.timed_out:
        server.handle_request()


mainloop = True


while mainloop:
        sleep(0.01)
        each_frame( )
        noteplayer( "/home/pi/osc/sound/")
        setVolume()
#       print (val)
            

server.close()                               

